/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.purchase.InAppPurchaseListener;
import com.google.android.gms.ads.purchase.PlayStorePurchaseListener;
import com.google.android.gms.internal.au;

public final class AdView
extends ViewGroup {
    private final au kx;

    public AdView(Context context) {
        super(context);
        this.kx = new au(this);
    }

    public AdView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.kx = new au(this, attrs, false);
    }

    public AdView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.kx = new au(this, attrs, false);
    }

    public void destroy() {
        this.kx.destroy();
    }

    public AdListener getAdListener() {
        return this.kx.getAdListener();
    }

    public AdSize getAdSize() {
        return this.kx.getAdSize();
    }

    public String getAdUnitId() {
        return this.kx.getAdUnitId();
    }

    public InAppPurchaseListener getInAppPurchaseListener() {
        return this.kx.getInAppPurchaseListener();
    }

    public void loadAd(AdRequest adRequest) {
        this.kx.a(adRequest.T());
    }

    public void pause() {
        this.kx.pause();
    }

    public void resume() {
        this.kx.resume();
    }

    public void setAdListener(AdListener adListener) {
        this.kx.setAdListener(adListener);
    }

    public void setAdSize(AdSize adSize) {
        this.kx.setAdSizes(adSize);
    }

    public void setAdUnitId(String adUnitId) {
        this.kx.setAdUnitId(adUnitId);
    }

    public void setInAppPurchaseListener(InAppPurchaseListener inAppPurchaseListener) {
        this.kx.setInAppPurchaseListener(inAppPurchaseListener);
    }

    public void setPlayStorePurchaseParams(PlayStorePurchaseListener playStorePurchaseListener, String publicKey) {
        this.kx.setPlayStorePurchaseParams(playStorePurchaseListener, publicKey);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n2 = view.getMeasuredWidth();
            int n3 = view.getMeasuredHeight();
            int n4 = (right - left - n2) / 2;
            int n5 = (bottom - top - n3) / 2;
            view.layout(n4, n5, n4 + n2, n5 + n3);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n2 = 0;
        int n3 = 0;
        View view = this.getChildAt(0);
        AdSize adSize = this.getAdSize();
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
            n2 = view.getMeasuredWidth();
            n3 = view.getMeasuredHeight();
        } else if (adSize != null) {
            Context context = this.getContext();
            n2 = adSize.getWidthInPixels(context);
            n3 = adSize.getHeightInPixels(context);
        }
        n2 = Math.max(n2, this.getSuggestedMinimumWidth());
        n3 = Math.max(n3, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n2, (int)widthMeasureSpec), View.resolveSize((int)n3, (int)heightMeasureSpec));
    }
}

