/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appstate;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.appstate.AppStateBuffer;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.ga;
import com.google.android.gms.internal.gy;
import com.google.android.gms.internal.hm;

public final class AppStateManager {
    static final Api.c<ga> yH = new Api.c();
    private static final Api.b<ga, Api.ApiOptions.NoOptions> yI = new Api.b<ga, Api.ApiOptions.NoOptions>(){

        public ga b(Context context, Looper looper, gy gy2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new ga(context, looper, connectionCallbacks, onConnectionFailedListener, gy2.fj(), gy2.fl().toArray(new String[0]));
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }

        @Override
        public /* synthetic */ Api.a a(Context context, Looper looper, gy gy2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.b(context, looper, gy2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };
    public static final Scope SCOPE_APP_STATE = new Scope("https://www.googleapis.com/auth/appstate");
    public static final Api<Api.ApiOptions.NoOptions> API = new Api<Api.ApiOptions.NoOptions>(yI, yH, SCOPE_APP_STATE);

    private AppStateManager() {
    }

    public static ga a(GoogleApiClient googleApiClient) {
        hm.b(googleApiClient != null, (Object)"GoogleApiClient parameter is required.");
        hm.a(googleApiClient.isConnected(), "GoogleApiClient must be connected.");
        ga ga2 = googleApiClient.a(yH);
        hm.a(ga2 != null, "GoogleApiClient is not configured to use the AppState API. Pass AppStateManager.API into GoogleApiClient.Builder#addApi() to use this feature.");
        return ga2;
    }

    public static int getMaxStateSize(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).dU();
    }

    public static int getMaxNumKeys(GoogleApiClient googleApiClient) {
        return AppStateManager.a(googleApiClient).dV();
    }

    private static StateResult e(final Status status) {
        return new StateResult(){

            @Override
            public Status getStatus() {
                return status;
            }

            @Override
            public StateLoadedResult getLoadedResult() {
                return null;
            }

            @Override
            public StateConflictResult getConflictResult() {
                return null;
            }

            @Override
            public void release() {
            }
        };
    }

    public static void update(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        googleApiClient.b(new e(){

            @Override
            protected void a(ga ga2) {
                ga2.a(null, stateKey, data);
            }
        });
    }

    public static PendingResult<StateResult> updateImmediate(GoogleApiClient googleApiClient, final int stateKey, final byte[] data) {
        return googleApiClient.b(new e(){

            @Override
            protected void a(ga ga2) {
                ga2.a(this, stateKey, data);
            }
        });
    }

    public static PendingResult<StateDeletedResult> delete(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.b(new b(){

            @Override
            protected void a(ga ga2) {
                ga2.a(this, stateKey);
            }

            public StateDeletedResult g(final Status status) {
                return new StateDeletedResult(){

                    @Override
                    public Status getStatus() {
                        return status;
                    }

                    @Override
                    public int getStateKey() {
                        return stateKey;
                    }
                };
            }

            @Override
            public /* synthetic */ Result c(Status status) {
                return this.g(status);
            }
        });
    }

    public static PendingResult<StateResult> load(GoogleApiClient googleApiClient, final int stateKey) {
        return googleApiClient.a(new e(){

            @Override
            protected void a(ga ga2) {
                ga2.b(this, stateKey);
            }
        });
    }

    public static PendingResult<StateListResult> list(GoogleApiClient googleApiClient) {
        return googleApiClient.a(new c(){

            @Override
            protected void a(ga ga2) {
                ga2.a(this);
            }
        });
    }

    public static PendingResult<StateResult> resolve(GoogleApiClient googleApiClient, final int stateKey, final String resolvedVersion, final byte[] resolvedData) {
        return googleApiClient.b(new e(){

            @Override
            protected void a(ga ga2) {
                ga2.a(this, stateKey, resolvedVersion, resolvedData);
            }
        });
    }

    public static PendingResult<Status> signOut(GoogleApiClient googleApiClient) {
        return googleApiClient.b(new d(){

            @Override
            protected void a(ga ga2) {
                ga2.b(this);
            }
        });
    }

    private static abstract class d
    extends a<Status> {
        private d() {
        }

        public Status d(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.d(status);
        }
    }

    private static abstract class c
    extends a<StateListResult> {
        private c() {
        }

        public StateListResult h(final Status status) {
            return new StateListResult(){

                @Override
                public Status getStatus() {
                    return status;
                }

                @Override
                public AppStateBuffer getStateBuffer() {
                    return new AppStateBuffer(null);
                }
            };
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.h(status);
        }
    }

    public static interface StateListResult
    extends Result {
        public AppStateBuffer getStateBuffer();
    }

    private static abstract class b
    extends a<StateDeletedResult> {
        private b() {
        }
    }

    public static interface StateDeletedResult
    extends Result {
        public int getStateKey();
    }

    private static abstract class e
    extends a<StateResult> {
        private e() {
        }

        public StateResult i(Status status) {
            return AppStateManager.e(status);
        }

        @Override
        public /* synthetic */ Result c(Status status) {
            return this.i(status);
        }
    }

    public static interface StateConflictResult
    extends Releasable,
    Result {
        public int getStateKey();

        public String getResolvedVersion();

        public byte[] getLocalData();

        public byte[] getServerData();
    }

    public static interface StateLoadedResult
    extends Releasable,
    Result {
        public int getStateKey();

        public byte[] getLocalData();
    }

    public static interface StateResult
    extends Releasable,
    Result {
        public StateLoadedResult getLoadedResult();

        public StateConflictResult getConflictResult();
    }

    public static abstract class a<R extends Result>
    extends a.b<R, ga> {
        public a() {
            super(yH);
        }
    }
}

