/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.b;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.gi;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final Parcelable.Creator<CastDevice> CREATOR = new b();
    private final int xM;
    private String Ah;
    String Ai;
    private Inet4Address Aj;
    private String Ak;
    private String Al;
    private String Am;
    private int An;
    private List<WebImage> Ao;
    private int Ap;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities) {
        this.xM = versionCode;
        this.Ah = deviceId;
        this.Ai = hostAddress;
        if (this.Ai != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.Ai);
                if (inetAddress instanceof Inet4Address) {
                    this.Aj = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.Aj = null;
            }
        }
        this.Ak = friendlyName;
        this.Al = modelName;
        this.Am = deviceVersion;
        this.An = servicePort;
        this.Ao = icons;
        this.Ap = capabilities;
    }

    private CastDevice() {
        this(2, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0);
    }

    int getVersionCode() {
        return this.xM;
    }

    public String getDeviceId() {
        return this.Ah;
    }

    public Inet4Address getIpAddress() {
        return this.Aj;
    }

    public String getFriendlyName() {
        return this.Ak;
    }

    public String getModelName() {
        return this.Al;
    }

    public String getDeviceVersion() {
        return this.Am;
    }

    public int getServicePort() {
        return this.An;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.Ao);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.Ao.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.Ao.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.Ao) {
            int n2 = webImage3.getWidth();
            int n3 = webImage3.getHeight();
            if (n2 >= preferredWidth && n3 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n2 || webImage.getHeight() <= n3)) continue;
                webImage = webImage3;
                continue;
            }
            if (n2 >= preferredWidth || n3 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n2 || webImage2.getHeight() >= n3)) continue;
            webImage2 = webImage3;
        }
        Object object = null;
        object = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.Ao.get(0));
        return object;
    }

    public boolean hasIcons() {
        return !this.Ao.isEmpty();
    }

    public int getCapabilities() {
        return this.Ap;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.Ak, this.Ah);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return gi.a(this.Ah, castDevice.Ah) && gi.a(this.Aj, castDevice.Aj) && gi.a(this.Al, castDevice.Al) && gi.a(this.Ak, castDevice.Ak) && gi.a(this.Am, castDevice.Am) && this.An == castDevice.An && gi.a(this.Ao, castDevice.Ao) && this.Ap == castDevice.Ap;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return gi.a(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.Ah == null ? 0 : this.Ah.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }
}

