/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.internal.gi;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.in;
import com.google.android.gms.internal.ip;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float Bs;
    private int Bt;
    private int td;
    private int Bu;
    private int Bv;
    private int Bw;
    private int Bx;
    private int By;
    private String Bz;
    private int BA;
    private int BB;
    private JSONObject AA;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.Bs = fontScale;
    }

    public float getFontScale() {
        return this.Bs;
    }

    public void setForegroundColor(int foregroundColor) {
        this.Bt = foregroundColor;
    }

    public int getForegroundColor() {
        return this.Bt;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.td = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.td;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.Bu = edgeType;
    }

    public int getEdgeType() {
        return this.Bu;
    }

    public void setEdgeColor(int edgeColor) {
        this.Bv = edgeColor;
    }

    public int getEdgeColor() {
        return this.Bv;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.Bw = windowType;
    }

    public int getWindowType() {
        return this.Bw;
    }

    public void setWindowColor(int windowColor) {
        this.Bx = windowColor;
    }

    public int getWindowColor() {
        return this.Bx;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.By = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.By;
    }

    public void setFontFamily(String fontFamily) {
        this.Bz = fontFamily;
    }

    public String getFontFamily() {
        return this.Bz;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.BA = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.BA;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.BB = fontStyle;
    }

    public int getFontStyle() {
        return this.BB;
    }

    public void setCustomData(JSONObject customData) {
        this.AA = customData;
    }

    public JSONObject getCustomData() {
        return this.AA;
    }

    private void clear() {
        this.Bs = 1.0f;
        this.Bt = 0;
        this.td = 0;
        this.Bu = -1;
        this.Bv = 0;
        this.Bw = -1;
        this.Bx = 0;
        this.By = 0;
        this.Bz = null;
        this.BA = -1;
        this.BB = -1;
        this.AA = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!ip.gi()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl2 = typeface.isBold();
            boolean bl3 = typeface.isItalic();
            if (bl2 && bl3) {
                textTrackStyle.setFontStyle(3);
            } else if (bl2) {
                textTrackStyle.setFontStyle(1);
            } else if (bl3) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void b(JSONObject jSONObject) throws JSONException {
        String string2;
        this.clear();
        this.Bs = (float)jSONObject.optDouble("fontScale", 1.0);
        this.Bt = this.ah(jSONObject.optString("foregroundColor"));
        this.td = this.ah(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string2 = jSONObject.getString("edgeType");
            if ("NONE".equals(string2)) {
                this.Bu = 0;
            } else if ("OUTLINE".equals(string2)) {
                this.Bu = 1;
            } else if ("DROP_SHADOW".equals(string2)) {
                this.Bu = 2;
            } else if ("RAISED".equals(string2)) {
                this.Bu = 3;
            } else if ("DEPRESSED".equals(string2)) {
                this.Bu = 4;
            }
        }
        this.Bv = this.ah(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string2 = jSONObject.getString("windowType");
            if ("NONE".equals(string2)) {
                this.Bw = 0;
            } else if ("NORMAL".equals(string2)) {
                this.Bw = 1;
            } else if ("ROUNDED_CORNERS".equals(string2)) {
                this.Bw = 2;
            }
        }
        this.Bx = this.ah(jSONObject.optString("windowColor"));
        if (this.Bw == 2) {
            this.By = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.Bz = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string2 = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string2)) {
                this.BA = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string2)) {
                this.BA = 1;
            } else if ("SERIF".equals(string2)) {
                this.BA = 2;
            } else if ("MONOSPACED_SERIF".equals(string2)) {
                this.BA = 3;
            } else if ("CASUAL".equals(string2)) {
                this.BA = 4;
            } else if ("CURSIVE".equals(string2)) {
                this.BA = 5;
            } else if ("SMALL_CAPITALS".equals(string2)) {
                this.BA = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string2 = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string2)) {
                this.BB = 0;
            } else if ("BOLD".equals(string2)) {
                this.BB = 1;
            } else if ("ITALIC".equals(string2)) {
                this.BB = 2;
            } else if ("BOLD_ITALIC".equals(string2)) {
                this.BB = 3;
            }
        }
        this.AA = jSONObject.optJSONObject("customData");
    }

    public JSONObject dZ() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.Bs);
            if (this.Bt != 0) {
                jSONObject.put("foregroundColor", (Object)this.o(this.Bt));
            }
            if (this.td != 0) {
                jSONObject.put("backgroundColor", (Object)this.o(this.td));
            }
            switch (this.Bu) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.Bv != 0) {
                jSONObject.put("edgeColor", (Object)this.o(this.Bv));
            }
            switch (this.Bw) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.Bx != 0) {
                jSONObject.put("windowColor", (Object)this.o(this.Bx));
            }
            if (this.Bw == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.By);
            }
            if (this.Bz != null) {
                jSONObject.put("fontFamily", (Object)this.Bz);
            }
            switch (this.BA) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.BB) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.AA != null) {
                jSONObject.put("customData", (Object)this.AA);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String o(int n2) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n2), Color.green((int)n2), Color.blue((int)n2), Color.alpha((int)n2));
    }

    private int ah(String string2) {
        if (string2 != null && string2.length() == 9 && string2.charAt(0) == '#') {
            try {
                int n2 = Integer.parseInt(string2.substring(1, 3), 16);
                int n3 = Integer.parseInt(string2.substring(3, 5), 16);
                int n4 = Integer.parseInt(string2.substring(5, 7), 16);
                int n5 = Integer.parseInt(string2.substring(7, 9), 16);
                return Color.argb((int)n5, (int)n2, (int)n3, (int)n4);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.AA == null != (textTrackStyle.AA == null)) {
            return false;
        }
        if (this.AA != null && textTrackStyle.AA != null && !in.d(this.AA, textTrackStyle.AA)) {
            return false;
        }
        return this.Bs == textTrackStyle.Bs && this.Bt == textTrackStyle.Bt && this.td == textTrackStyle.td && this.Bu == textTrackStyle.Bu && this.Bv == textTrackStyle.Bv && this.Bw == textTrackStyle.Bw && this.By == textTrackStyle.By && gi.a(this.Bz, textTrackStyle.Bz) && this.BA == textTrackStyle.BA && this.BB == textTrackStyle.BB;
    }

    public int hashCode() {
        return hk.hashCode(Float.valueOf(this.Bs), this.Bt, this.td, this.Bu, this.Bv, this.Bw, this.Bx, this.By, this.Bz, this.BA, this.BB, this.AA);
    }
}

