/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevelCreator;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.hm;

public final class PlayerLevel
implements SafeParcelable {
    public static final PlayerLevelCreator CREATOR = new PlayerLevelCreator();
    private final int xM;
    private final int MZ;
    private final long Na;
    private final long Nb;

    public PlayerLevel(int value, long minXp, long maxXp) {
        this(1, value, minXp, maxXp);
    }

    PlayerLevel(int versionCode, int levelNumber, long minXp, long maxXp) {
        hm.a(minXp >= 0L, "Min XP must be positive!");
        hm.a(maxXp > minXp, "Max XP must be more than min XP!");
        this.xM = versionCode;
        this.MZ = levelNumber;
        this.Na = minXp;
        this.Nb = maxXp;
    }

    public int getVersionCode() {
        return this.xM;
    }

    public int getLevelNumber() {
        return this.MZ;
    }

    public long getMinXp() {
        return this.Na;
    }

    public long getMaxXp() {
        return this.Nb;
    }

    public int hashCode() {
        return hk.hashCode(this.MZ, this.Na, this.Nb);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevel)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PlayerLevel playerLevel = (PlayerLevel)obj;
        return hk.equal(playerLevel.getLevelNumber(), this.getLevelNumber()) && hk.equal(playerLevel.getMinXp(), this.getMinXp()) && hk.equal(playerLevel.getMaxXp(), this.getMaxXp());
    }

    public String toString() {
        return hk.e(this).a("LevelNumber", this.getLevelNumber()).a("MinXp", this.getMinXp()).a("MaxXp", this.getMaxXp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelCreator.a(this, out, flags);
    }
}

