/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.PlayerLevel;
import com.google.android.gms.games.PlayerLevelInfoCreator;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.hm;

public final class PlayerLevelInfo
implements SafeParcelable {
    public static final PlayerLevelInfoCreator CREATOR = new PlayerLevelInfoCreator();
    private final int xM;
    private final long Nc;
    private final long Nd;
    private final PlayerLevel Ne;
    private final PlayerLevel Nf;

    public PlayerLevelInfo(long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        this(1, currentXpTotal, lastLevelUpTimestamp, currentLevel, nextLevel);
    }

    PlayerLevelInfo(int versionCode, long currentXpTotal, long lastLevelUpTimestamp, PlayerLevel currentLevel, PlayerLevel nextLevel) {
        hm.A(currentXpTotal != -1L);
        hm.f(currentLevel);
        hm.f(nextLevel);
        this.xM = versionCode;
        this.Nc = currentXpTotal;
        this.Nd = lastLevelUpTimestamp;
        this.Ne = currentLevel;
        this.Nf = nextLevel;
    }

    public int getVersionCode() {
        return this.xM;
    }

    public long getCurrentXpTotal() {
        return this.Nc;
    }

    public long getLastLevelUpTimestamp() {
        return this.Nd;
    }

    public PlayerLevel getCurrentLevel() {
        return this.Ne;
    }

    public PlayerLevel getNextLevel() {
        return this.Nf;
    }

    public boolean isMaxLevel() {
        return this.Ne.equals(this.Nf);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PlayerLevelInfo)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PlayerLevelInfo playerLevelInfo = (PlayerLevelInfo)obj;
        return hk.equal(this.Nc, playerLevelInfo.Nc) && hk.equal(this.Nd, playerLevelInfo.Nd) && hk.equal(this.Ne, playerLevelInfo.Ne) && hk.equal(this.Nf, playerLevelInfo.Nf);
    }

    public int hashCode() {
        return hk.hashCode(this.Nc, this.Nd, this.Ne, this.Nf);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        PlayerLevelInfoCreator.a(this, out, flags);
    }
}

