/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.hk;
import com.google.android.gms.internal.ik;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int xM;
    private final String Oq;
    private final String Ln;
    private final Uri Mr;
    private final Uri Ms;
    private final int Tb;
    private final String Nn;
    private final boolean Tc;
    private final PlayerEntity Nj;
    private final int Ap;
    private final ParticipantResult Td;
    private final String MC;
    private final String MD;

    public ParticipantEntity(Participant participant) {
        this.xM = 3;
        this.Oq = participant.getParticipantId();
        this.Ln = participant.getDisplayName();
        this.Mr = participant.getIconImageUri();
        this.Ms = participant.getHiResImageUri();
        this.Tb = participant.getStatus();
        this.Nn = participant.gW();
        this.Tc = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.Nj = player == null ? null : new PlayerEntity(player);
        this.Ap = participant.getCapabilities();
        this.Td = participant.getResult();
        this.MC = participant.getIconImageUrl();
        this.MD = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.xM = versionCode;
        this.Oq = participantId;
        this.Ln = displayName;
        this.Mr = iconImageUri;
        this.Ms = hiResImageUri;
        this.Tb = status;
        this.Nn = clientAddress;
        this.Tc = connectedToRoom;
        this.Nj = player;
        this.Ap = capabilities;
        this.Td = result;
        this.MC = iconImageUrl;
        this.MD = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public int getStatus() {
        return this.Tb;
    }

    @Override
    public String gW() {
        return this.Nn;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.Tc;
    }

    @Override
    public String getDisplayName() {
        if (this.Nj == null) {
            return this.Ln;
        }
        return this.Nj.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.Nj == null) {
            ik.b(this.Ln, dataOut);
            return;
        }
        this.Nj.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.Nj == null) {
            return this.Mr;
        }
        return this.Nj.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.Nj == null) {
            return this.MC;
        }
        return this.Nj.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.Nj == null) {
            return this.Ms;
        }
        return this.Nj.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.Nj == null) {
            return this.MD;
        }
        return this.Nj.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.Oq;
    }

    @Override
    public Player getPlayer() {
        return this.Nj;
    }

    @Override
    public ParticipantResult getResult() {
        return this.Td;
    }

    @Override
    public int getCapabilities() {
        return this.Ap;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return hk.hashCode(participant.getPlayer(), participant.getStatus(), participant.gW(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return hk.equal(participant2.getPlayer(), participant.getPlayer()) && hk.equal(participant2.getStatus(), participant.getStatus()) && hk.equal(participant2.gW(), participant.gW()) && hk.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && hk.equal(participant2.getDisplayName(), participant.getDisplayName()) && hk.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && hk.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && hk.equal(participant2.getCapabilities(), participant.getCapabilities()) && hk.equal(participant2.getResult(), participant.getResult()) && hk.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return hk.e(participant).a("ParticipantId", participant.getParticipantId()).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.gW()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.fr()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Oq);
            dest.writeString(this.Ln);
            dest.writeString(this.Mr == null ? null : this.Mr.toString());
            dest.writeString(this.Ms == null ? null : this.Ms.toString());
            dest.writeInt(this.Tb);
            dest.writeString(this.Nn);
            dest.writeInt(this.Tc ? 1 : 0);
            dest.writeInt(this.Nj == null ? 0 : 1);
            if (this.Nj != null) {
                this.Nj.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity bm(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.fq());
            if (bl2 || ParticipantEntity.aA(ParticipantEntity.class.getCanonicalName())) {
                return super.bm(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string7 = null;
            String string8 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3, participantResult, string7, string8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.bm(x0);
        }
    }
}

