/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import com.google.android.gms.internal.hk;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int xM;
    private final GameEntity Rt;
    private final PlayerEntity Ua;
    private final byte[] TF;
    private final String OB;
    private final ArrayList<PlayerEntity> Ub;
    private final int AT;
    private final long SU;
    private final long Uc;
    private final Bundle Ud;
    private final int Tb;

    public GameRequestEntity(GameRequest request) {
        this.xM = 2;
        this.Rt = new GameEntity(request.getGame());
        this.Ua = new PlayerEntity(request.getSender());
        this.OB = request.getRequestId();
        this.AT = request.getType();
        this.SU = request.getCreationTimestamp();
        this.Uc = request.getExpirationTimestamp();
        this.Tb = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.TF = null;
        } else {
            this.TF = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.TF, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n2 = list.size();
        this.Ub = new ArrayList(n2);
        this.Ud = new Bundle();
        for (int i2 = 0; i2 < n2; ++i2) {
            Player player = (Player)list.get(i2).freeze();
            String string2 = player.getPlayerId();
            this.Ub.add((PlayerEntity)player);
            this.Ud.putInt(string2, request.getRecipientStatus(string2));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.xM = versionCode;
        this.Rt = game;
        this.Ua = sender;
        this.TF = data;
        this.OB = requestId;
        this.Ub = recipients;
        this.AT = type;
        this.SU = creationTimestamp;
        this.Uc = expirationTimestamp;
        this.Ud = recipientStatuses;
        this.Tb = status;
    }

    public int getVersionCode() {
        return this.xM;
    }

    @Override
    public String getRequestId() {
        return this.OB;
    }

    @Override
    public Game getGame() {
        return this.Rt;
    }

    @Override
    public Player getSender() {
        return this.Ua;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.Ub);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.TF;
    }

    @Override
    public int getType() {
        return this.AT;
    }

    @Override
    public long getCreationTimestamp() {
        return this.SU;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.Uc;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.Ud.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.Tb;
    }

    public Bundle iL() {
        return this.Ud;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return hk.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return hk.equal(gameRequest2.getGame(), gameRequest.getGame()) && hk.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && hk.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && hk.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && hk.equal(gameRequest2.getType(), gameRequest.getType()) && hk.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && hk.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = gameRequest.getRecipientStatus(list.get(i2).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return hk.e(gameRequest).a("Game", gameRequest.getGame()).a("Sender", gameRequest.getSender()).a("Recipients", gameRequest.getRecipients()).a("Data", gameRequest.getData()).a("RequestId", gameRequest.getRequestId()).a("Type", gameRequest.getType()).a("CreationTimestamp", gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

