/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.hc;
import com.google.android.gms.internal.hd;
import com.google.android.gms.internal.hh;
import com.google.android.gms.internal.hi;
import com.google.android.gms.internal.hm;
import java.util.ArrayList;

public abstract class hb<T extends IInterface>
implements Api.a,
hc.b {
    private final Context mContext;
    private final Looper DF;
    final Handler mHandler;
    private T Gb;
    private final ArrayList<b<?>> Gc = new ArrayList();
    private f Gd;
    private volatile int Ge = 1;
    private final String[] Gf;
    boolean Gg = false;
    private final hc DS;
    public static final String[] Gh = new String[]{"service_esmobile", "service_googleme"};

    protected hb(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = hm.f(context);
        this.DF = hm.b(looper, (Object)"Looper must not be null");
        this.DS = new hc(context, looper, this);
        this.mHandler = new a(looper);
        this.b(stringArray);
        this.Gf = stringArray;
        this.registerConnectionCallbacks(hm.f(connectionCallbacks));
        this.registerConnectionFailedListener(hm.f(onConnectionFailedListener));
    }

    @Deprecated
    protected hb(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this(context, context.getMainLooper(), new c(connectionCallbacks), new g(onConnectionFailedListener), stringArray);
    }

    protected void b(String ... stringArray) {
    }

    protected abstract String bu();

    protected abstract String bv();

    protected abstract T x(IBinder var1);

    private void am(int n2) {
        int n3 = this.Ge;
        this.Ge = n2;
        if (n3 != n2) {
            if (n2 == 3) {
                this.onConnected();
            } else if (n3 == 3 && n2 == 1) {
                this.onDisconnected();
            }
        }
    }

    protected void onConnected() {
    }

    protected void onDisconnected() {
    }

    @Override
    public void connect() {
        this.Gg = true;
        this.am(2);
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.am(1);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.Gd != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.Gb = null;
            hd.E(this.mContext).b(this.bu(), this.Gd);
        }
        this.Gd = new f();
        boolean bl2 = hd.E(this.mContext).a(this.bu(), this.Gd);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.bu()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.Ge == 3;
    }

    public boolean isConnecting() {
        return this.Ge == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.Gg = false;
        ArrayList<b<?>> arrayList = this.Gc;
        synchronized (arrayList) {
            int n2 = this.Gc.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Gc.get(i2).fw();
            }
            this.Gc.clear();
        }
        this.am(1);
        this.Gb = null;
        if (this.Gd != null) {
            hd.E(this.mContext).b(this.bu(), this.Gd);
            this.Gd = null;
        }
    }

    public void an(int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)n2));
    }

    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public final Looper getLooper() {
        return this.DF;
    }

    public final String[] fs() {
        return this.Gf;
    }

    protected final void I(IBinder iBinder) {
        try {
            hi hi2 = hi.a.L(iBinder);
            this.a(hi2, new e(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(hi var1, e var2) throws RemoteException;

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new h(n2, iBinder, bundle)));
    }

    protected final void cn() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle ef() {
        return null;
    }

    public final T ft() {
        this.cn();
        return this.Gb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.Gc;
        synchronized (arrayList) {
            this.Gc.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    @Override
    public boolean eO() {
        return this.Gg;
    }

    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        this.DS.registerConnectionCallbacks(listener);
    }

    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        this.DS.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.DS.registerConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.DS.isConnectionCallbacksRegistered(new c(listener));
    }

    @Deprecated
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.DS.unregisterConnectionCallbacks(new c(listener));
    }

    @Deprecated
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.DS.registerConnectionFailedListener(listener);
    }

    @Deprecated
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.DS.isConnectionFailedListenerRegistered(listener);
    }

    @Deprecated
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.DS.unregisterConnectionFailedListener(listener);
    }

    public static final class e
    extends hh.a {
        private hb Gl;

        public e(hb hb2) {
            this.Gl = hb2;
        }

        @Override
        public void b(int n2, IBinder iBinder, Bundle bundle) {
            hm.b("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.Gl);
            this.Gl.a(n2, iBinder, bundle);
            this.Gl = null;
        }
    }

    protected final class h
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle Gn;
        public final IBinder Go;

        public h(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.Go = iBinder;
            this.Gn = bundle;
        }

        protected void b(Boolean bl2) {
            if (bl2 == null) {
                hb.this.am(1);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.Go.getInterfaceDescriptor();
                        if (hb.this.bv().equals(string2)) {
                            hb.this.Gb = hb.this.x(this.Go);
                            if (hb.this.Gb != null) {
                                hb.this.am(3);
                                hb.this.DS.cp();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    hd.E(hb.this.mContext).b(hb.this.bu(), hb.this.Gd);
                    hb.this.Gd = null;
                    hb.this.am(1);
                    hb.this.Gb = null;
                    hb.this.DS.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    hb.this.am(1);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.Gn != null) {
                        pendingIntent = (PendingIntent)this.Gn.getParcelable("pendingIntent");
                    }
                    if (hb.this.Gd != null) {
                        hd.E(hb.this.mContext).b(hb.this.bu(), hb.this.Gd);
                        hb.this.Gd = null;
                    }
                    hb.this.am(1);
                    hb.this.Gb = null;
                    hb.this.DS.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void fu() {
        }

        @Override
        protected /* synthetic */ void d(Object object) {
            this.b((Boolean)object);
        }
    }

    public static final class g
    implements GoogleApiClient.OnConnectionFailedListener {
        private final GooglePlayServicesClient.OnConnectionFailedListener Gm;

        public g(GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.Gm = onConnectionFailedListener;
        }

        @Override
        public void onConnectionFailed(ConnectionResult result) {
            this.Gm.onConnectionFailed(result);
        }

        public boolean equals(Object other) {
            if (other instanceof g) {
                return this.Gm.equals(((g)other).Gm);
            }
            return this.Gm.equals(other);
        }
    }

    public static final class c
    implements GoogleApiClient.ConnectionCallbacks {
        private final GooglePlayServicesClient.ConnectionCallbacks Gk;

        public c(GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks) {
            this.Gk = connectionCallbacks;
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            this.Gk.onConnected(connectionHint);
        }

        @Override
        public void onConnectionSuspended(int cause) {
            this.Gk.onDisconnected();
        }

        public boolean equals(Object other) {
            if (other instanceof c) {
                return this.Gk.equals(((c)other).Gk);
            }
            return this.Gk.equals(other);
        }
    }

    public abstract class d<TListener>
    extends b<TListener> {
        private final DataHolder DG;

        public d(TListener TListener, DataHolder dataHolder) {
            super(TListener);
            this.DG = dataHolder;
        }

        @Override
        protected final void d(TListener TListener) {
            this.a(TListener, this.DG);
        }

        protected abstract void a(TListener var1, DataHolder var2);

        @Override
        protected void fu() {
            if (this.DG != null) {
                this.DG.close();
            }
        }
    }

    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean Gj;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.Gj = false;
        }

        protected abstract void d(TListener var1);

        protected abstract void fu();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fv() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.Gj) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.d(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.fu();
                    throw runtimeException;
                }
            } else {
                this.fu();
            }
            b2 = this;
            synchronized (b2) {
                this.Gj = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.fw();
            ArrayList arrayList = hb.this.Gc;
            synchronized (arrayList) {
                hb.this.Gc.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fw() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 1 && !hb.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.fu();
                b2.unregister();
                return;
            }
            if (msg.what == 3) {
                hb.this.DS.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                hb.this.am(1);
                hb.this.Gb = null;
                hb.this.DS.ao((Integer)msg.obj);
                return;
            }
            if (msg.what == 2 && !hb.this.isConnected()) {
                b b3 = (b)msg.obj;
                b3.fu();
                b3.unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                b b4 = (b)msg.obj;
                b4.fv();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class f
    implements ServiceConnection {
        f() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            hb.this.I(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            hb.this.mHandler.sendMessage(hb.this.mHandler.obtainMessage(4, (Object)1));
        }
    }
}

