/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.dynamic.e;
import com.google.android.gms.dynamic.f;
import com.google.android.gms.internal.hm;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.t;
import com.google.android.gms.maps.internal.u;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public class MapFragment
extends Fragment {
    private final b ZC = new b(this);
    private GoogleMap ZD;

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    public static MapFragment newInstance(GoogleMapOptions options) {
        MapFragment mapFragment = new MapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)options);
        mapFragment.setArguments(bundle);
        return mapFragment;
    }

    protected IMapFragmentDelegate jy() {
        this.ZC.jz();
        if (this.ZC.gH() == null) {
            return null;
        }
        return ((a)this.ZC.gH()).jy();
    }

    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.jy();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.ZD == null || this.ZD.jp().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.ZD = new GoogleMap(iGoogleMapDelegate);
        }
        return this.ZD;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.ZC.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        this.ZC.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attrs);
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.ZC.onInflate(activity, bundle, savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.ZC.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return this.ZC.onCreateView(inflater, container, savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.ZC.onResume();
    }

    public void onPause() {
        this.ZC.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.ZC.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.ZC.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.ZC.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            savedInstanceState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onSaveInstanceState(Bundle outState) {
        if (outState != null) {
            outState.setClassLoader(MapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(outState);
        this.ZC.onSaveInstanceState(outState);
    }

    public void setArguments(Bundle args) {
        super.setArguments(args);
    }

    static class b
    extends com.google.android.gms.dynamic.a<a> {
        private final Fragment Mj;
        protected f<a> ZF;
        private Activity og;

        b(Fragment fragment) {
            this.Mj = fragment;
        }

        @Override
        protected void a(f<a> f2) {
            this.ZF = f2;
            this.jz();
        }

        public void jz() {
            if (this.og != null && this.ZF != null && this.gH() == null) {
                try {
                    MapsInitializer.initialize((Context)this.og);
                    IMapFragmentDelegate iMapFragmentDelegate = u.H((Context)this.og).i(e.h(this.og));
                    this.ZF.a(new a(this.Mj, iMapFragmentDelegate));
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.og = activity;
            this.jz();
        }
    }

    static class a
    implements LifecycleDelegate {
        private final Fragment Mj;
        private final IMapFragmentDelegate ZE;

        public a(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.ZE = hm.f(iMapFragmentDelegate);
            this.Mj = hm.f(fragment);
        }

        @Override
        public void onInflate(Activity activity, Bundle attrs, Bundle savedInstanceState) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)attrs.getParcelable("MapOptions");
            try {
                this.ZE.onInflate(e.h(activity), googleMapOptions, savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onCreate(Bundle savedInstanceState) {
            try {
                Bundle bundle;
                if (savedInstanceState == null) {
                    savedInstanceState = new Bundle();
                }
                if ((bundle = this.Mj.getArguments()) != null && bundle.containsKey("MapOptions")) {
                    t.a(savedInstanceState, "MapOptions", bundle.getParcelable("MapOptions"));
                }
                this.ZE.onCreate(savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
            d d2;
            try {
                d2 = this.ZE.onCreateView(e.h(inflater), e.h(container), savedInstanceState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)e.e(d2);
        }

        @Override
        public void onStart() {
        }

        @Override
        public void onResume() {
            try {
                this.ZE.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onPause() {
            try {
                this.ZE.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public void onDestroyView() {
            try {
                this.ZE.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onDestroy() {
            try {
                this.ZE.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onLowMemory() {
            try {
                this.ZE.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        @Override
        public void onSaveInstanceState(Bundle outState) {
            try {
                this.ZE.onSaveInstanceState(outState);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate jy() {
            return this.ZE;
        }
    }
}

