/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.internal.hm;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int xM;
    private BitmapDescriptor aaA;
    private LatLng aaB;
    private float aaC;
    private float aaD;
    private LatLngBounds aaE;
    private float aaq;
    private float aax;
    private boolean aay = true;
    private float aaF = 0.0f;
    private float aaG = 0.5f;
    private float aaH = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.xM = versionCode;
        this.aaA = new BitmapDescriptor(d.a.ag(wrappedImage));
        this.aaB = location;
        this.aaC = width;
        this.aaD = height;
        this.aaE = bounds;
        this.aaq = bearing;
        this.aax = zIndex;
        this.aay = visible;
        this.aaF = transparency;
        this.aaG = anchorU;
        this.aaH = anchorV;
    }

    public GroundOverlayOptions() {
        this.xM = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.jL()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder jN() {
        return this.aaA.jn().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.aaA = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.aaG = u2;
        this.aaH = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        hm.a(this.aaE == null, "Position has already been set using positionFromBounds");
        hm.b(location != null, (Object)"Location must be specified");
        hm.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        hm.a(this.aaE == null, "Position has already been set using positionFromBounds");
        hm.b(location != null, (Object)"Location must be specified");
        hm.b(width >= 0.0f, (Object)"Width must be non-negative");
        hm.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.aaB = latLng;
        this.aaC = f2;
        this.aaD = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        hm.a(this.aaB == null, "Position has already been set using position: %s", this.aaB);
        this.aaE = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.aaq = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.aax = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.aay = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        hm.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.aaF = transparency;
        return this;
    }

    int getVersionCode() {
        return this.xM;
    }

    public BitmapDescriptor getImage() {
        return this.aaA;
    }

    public LatLng getLocation() {
        return this.aaB;
    }

    public float getWidth() {
        return this.aaC;
    }

    public float getHeight() {
        return this.aaD;
    }

    public LatLngBounds getBounds() {
        return this.aaE;
    }

    public float getBearing() {
        return this.aaq;
    }

    public float getZIndex() {
        return this.aax;
    }

    public float getTransparency() {
        return this.aaF;
    }

    public float getAnchorU() {
        return this.aaG;
    }

    public float getAnchorV() {
        return this.aaH;
    }

    public boolean isVisible() {
        return this.aay;
    }
}

