/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.internal.hm;
import com.google.android.gms.internal.hp;
import com.google.android.gms.plus.internal.g;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View abB;
    private int mSize;
    private int abC;
    private String qY;
    private int abD;
    private OnPlusOneClickListener abE;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.abC = PlusOneButton.getAnnotation(context, attrs);
        this.abD = -1;
        this.C(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attrs) {
        String string2 = hp.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "size", context, attrs, true, false, "PlusOneButton");
        return "SMALL".equalsIgnoreCase(string2) ? 0 : ("MEDIUM".equalsIgnoreCase(string2) ? 1 : ("TALL".equalsIgnoreCase(string2) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attrs) {
        String string2 = hp.a("http://schemas.android.com/apk/lib/com.google.android.gms.plus", "annotation", context, attrs, true, false, "PlusOneButton");
        return "INLINE".equalsIgnoreCase(string2) ? 2 : ("NONE".equalsIgnoreCase(string2) ? 0 : 1);
    }

    private void C(Context context) {
        if (this.abB != null) {
            this.removeView(this.abB);
        }
        this.abB = g.a(context, this.mSize, this.abC, this.qY, this.abD);
        this.setOnPlusOneClickListener(this.abE);
        this.addView(this.abB);
    }

    public void initialize(String url, int activityRequestCode) {
        hm.a(this.getContext() instanceof Activity, "To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.qY = url;
        this.abD = activityRequestCode;
        this.C(this.getContext());
    }

    public void initialize(String url, OnPlusOneClickListener plusOneClickListener) {
        this.qY = url;
        this.abD = 0;
        this.C(this.getContext());
        this.setOnPlusOneClickListener(plusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener listener) {
        this.abE = listener;
        this.abB.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(listener));
    }

    public void setAnnotation(int annotation) {
        this.abC = annotation;
        this.C(this.getContext());
    }

    public void setSize(int size) {
        this.mSize = size;
        this.C(this.getContext());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View view = this.abB;
        this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.abB.layout(0, 0, right - left, bottom - top);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener abF;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener proxy) {
            this.abF = proxy;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.abB.getTag();
            if (this.abF != null) {
                this.abF.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.abD);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

